#!/bin/bash

# Marker for Creators Import - Installer
# Installiert die Premiere Pro Extension automatisch

clear
echo "========================================"
echo " Marker for Creators Import Installer"
echo "========================================"
echo ""

# Extension Ordner
EXT_DIR="$HOME/Library/Application Support/Adobe/CEP/extensions/MarkerForCreators"

# Erstelle Extension Ordner
echo "📁 Erstelle Extension-Ordner..."
mkdir -p "$EXT_DIR"
mkdir -p "$EXT_DIR/CSXS"
mkdir -p "$EXT_DIR/jsx"
mkdir -p "$EXT_DIR/lib"

# Pfad zum Script-Ordner
SCRIPT_DIR="$(cd "$(dirname "$0")" && pwd)"

echo "📦 Kopiere Extension-Dateien..."
cp -r "$SCRIPT_DIR/CSXS/" "$EXT_DIR/CSXS/"
cp -r "$SCRIPT_DIR/jsx/" "$EXT_DIR/jsx/"
cp -r "$SCRIPT_DIR/lib/" "$EXT_DIR/lib/"
cp "$SCRIPT_DIR/index.html" "$EXT_DIR/"
cp "$SCRIPT_DIR/.debug" "$EXT_DIR/" 2>/dev/null || true

# Aktiviere Debug-Modus
echo "🔧 Aktiviere Debug-Modus..."
defaults write com.adobe.CSXS.10 PlayerDebugMode 1
defaults write com.adobe.CSXS.11 PlayerDebugMode 1

echo ""
echo "✅ Installation erfolgreich!"
echo ""
echo "📍 Extension installiert in:"
echo "   $EXT_DIR"
echo ""
echo "🎬 Nächste Schritte:"
echo "   1. Starte Premiere Pro neu"
echo "   2. Gehe zu: Fenster → Erweiterungen → Marker for Creators Import"
echo ""
echo "Drücke Enter zum Beenden..."
read

exit 0
